/**
 * Created by lei.wang_1 on 2016/11/22.
 */
appModule.directive("replyItem", [ "utils","$rootScope","notices","pages", function (utils,$rootScope,notices,pages) {
    return {
        template: `<div class="{{item.type}}" ng-switch="item.type">
                        <span ng-switch-when="text" class="content text-ellipsis" ng-bind="item.data[0].content"></span>
                        <div ng-switch-when="image" class="content">
                            <div class="imageContainer">
                                <notice-image isrc="item.data[0].src" size="24" image-adapter></notice-image>
                                <div class="previewContainer">
                                    <div class="inner">
                                        <notice-image isrc="item.data[0].src" size="320" image-adapter></notice-image>
                                    </div>
                                    <div class="info" ng-show="item.data[0].shootTime || item.data[0].address">
                                        <div class="shootItem" ng-show="item.data[0].shoot_time">
                                            <label translate="task.audit.shoot-time"></label>
                                            <span class="timeSpan" ng-bind="convertTime(item.data[0].shoot_time)"></span>
                                        </div>
                                        <div class="shootItem" ng-show="item.data[0].address">
                                            <label translate="task.audit.shoot-location"></label>
                                            <a class="address" ng-click="showMap(item.data[0].location,$event)">
                                                <span ng-bind="item.data[0].address" class="text-ellipsis"></span>
                                            </a>
                                        </div>
                                        <div class="shootItem" ng-show="item.data[0].description">
                                            <label translate="task.audit.shoot-description"></label>
                                            <a class="address description">
                                                <span ng-bind="item.data[0].description" class="text-ellipsis"></span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="imageCount" ng-bind="item.data.length"></div>
                        </div>
                        <div ng-switch-when="audio" class="content">
                            <div class="audioWrapper" ng-class="{'playing':item.data[0].isPlaying}" ng-click="toggleAudioPlaying(item.data[0],$event)">
                                 <i class="control" ng-class="{'play': !item.data[0].isPlaying,'stop':item.data[0].isPlaying}"></i>
                                 <span class="line"></span><notice-time-line duration="item.data[0].duration"></notice-time-line>
                            </div>
                        </div>
                    </div>`,
        restrict: "AE",
        replace: true,
        scope: {
            item: "="
        },
        link: function ($scope) {
            $scope.stopAudioPlaying = function (audio) {
                utils.stopPlayMedia();
                audio.isPlaying = false;
                if(audio.originDuration){
                    audio.duration = audio.originDuration;
                }
            };

            $scope.toggleAudioPlaying = function (audio, e) {
                if (e) {
                    e.stopPropagation();
                }

                if ($rootScope.currentPlayingAudio == audio && audio.isPlaying) {
                    $scope.stopAudioPlaying(audio);
                    $rootScope.currentPlayingAudio = null;
                    return;
                }

                if ($rootScope.currentPlayingAudio) {
                    $scope.stopAudioPlaying($rootScope.currentPlayingAudio);
                }
                audio.originDuration = audio.duration;
                audio.isPlaying = true;
                $rootScope.currentPlayingAudio = audio;
                utils.playMedia(audio.src, function (id, percent, seconds) {
                    if ($rootScope.currentPlayingAudio && $rootScope.currentPlayingAudio.src == id) {
                        utils.applyScope($scope, function () {
                            $rootScope.currentPlayingAudio.duration = percent * seconds * 10;
                            if (percent === 100) {
                                $rootScope.currentPlayingAudio.duration = audio.originDuration;
                                $rootScope.currentPlayingAudio.isPlaying = false;
                            }
                        });
                    }
                }, function (path, backURL) {
                    if ($rootScope.currentPlayingAudio.src == backURL) {
                        utils.applyScope($scope, function () {
                            $rootScope.currentPlayingAudio.src = path;
                        });
                    }
                });
            };

            $scope.convertTime = function (source) {//将日期转化成视觉要求
                return notices.convertNoticeTime(source);
            };

            $scope.showMap = function (address, e) {
                e.preventDefault();
                e.stopPropagation();
                var url = 'map.html?latitude=' + address.latitude + '&longitude=' + address.longitude;
                pages.openModalDialog(url, 'detail', 760, 720, $scope, {
                    modal: false,
                    caption: [{
                        left: 0,
                        top: 5,
                        width: 90,
                        height: 20
                    }, {
                        left: 150,
                        top: 5,
                        width: -100,
                        height: 40
                    }],
                    resizable: false,
                    refreshIfExist: true,
                    enableDrag: true,
                    showCloseButton: true,
                    showMinimalButton: false,
                    showFullScreenButton: false
                });
            };

            var offStopPlayingAudio = $scope.$on('stopPlayingAudio',function(){
                if($scope.item.type == 'audio'){
                    $scope.stopAudioPlaying($scope.item.data[0]);
                }
            });

            $scope.$on('$destroy',function(){
                offStopPlayingAudio();
            });
        }
    };
}]);